import numpy as np


def get_average_support(
        P,
        v_mapping,
        c_mapping,
        num_v_clusters,
        num_c_clusters
):
    # average support of each voter cluster for a given candidate cluster
    avg_support = np.zeros((num_v_clusters, num_c_clusters))
    normalizer = np.zeros((num_v_clusters, num_c_clusters))
    for i in range(P.shape[0]):
        for j in range(P.shape[1]):
            avg_support[v_mapping[i], c_mapping[j]] += P[i, j]
            normalizer[v_mapping[i], c_mapping[j]] += 1

    avg_support = np.divide(avg_support, normalizer,
                            out=np.zeros_like(avg_support), where=normalizer != 0)

    return avg_support